package ru.yandex.juggler.target;

import java.util.List;
import java.util.Optional;
import java.util.Random;

import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

import ru.yandex.juggler.relay.JugglerRelay;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class TargetState {
    private static final TargetState EMPTY = new TargetState(List.of(), new IntArrayList(new int[0]));

    /* How many times to roll the dice before considering that all relays are down */
    private static final int maxRetriesForReadyCheck = 10;
    private final WeightedChoice<JugglerRelay> choice;

    public static TargetState of() {
        return EMPTY;
    }

    public static TargetState of(JugglerRelay relay, int weight) {
        return new TargetState(List.of(relay), IntArrayList.wrap(new int[] { weight }));
    }

    public static TargetState of(JugglerRelay relay1, int weight1, JugglerRelay relay2, int weight2) {
        return new TargetState(List.of(relay1, relay2), IntArrayList.wrap(new int[] { weight1, weight2 }));
    }

    public static TargetState of(JugglerRelay relay1, int weight1, JugglerRelay relay2, int weight2, JugglerRelay relay3, int weight3) {
        return new TargetState(List.of(relay1, relay2, relay3), IntArrayList.wrap(new int[] { weight1, weight2, weight3 }));
    }

    public TargetState(List<JugglerRelay> relays, IntList weights) {
        // ThreadLocalRandom.current() behaves strange (yields same sequence) when test is repeated in IDEA
        this.choice = new WeightedChoice<>(relays, weights, new Random(), maxRetriesForReadyCheck);
    }

    public Optional<JugglerRelay> chooseRelay() {
        return choice.choose();
    }
}
