package ru.yandex.juggler.future;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class CompletableFutureWithCounterTest {
    private static class Response implements StatusAware {
        private final boolean status;

        private Response(boolean status) {
            this.status = status;
        }

        @Override
        public boolean isOk() {
            return status;
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void empty() {
        new CompletableFutureWithCounter<>(List.of());
    }

    @Test
    public void singleOk() {
        CompletableFuture<Response> future = new CompletableFuture<>();

        CompletableFutureWithCounter<Response> union = new CompletableFutureWithCounter<>(List.of(future));

        Response r = new Response(true);
        future.completeOnTimeout(r, 100, TimeUnit.MILLISECONDS);

        Assert.assertEquals(List.of(r), union.join());
    }

    @Test
    public void singleBad() {
        CompletableFuture<Response> future = new CompletableFuture<>();

        CompletableFutureWithCounter<Response> union = new CompletableFutureWithCounter<>(List.of(future));

        Response r = new Response(false);
        future.completeOnTimeout(r, 100, TimeUnit.MILLISECONDS);

        Assert.assertEquals(List.of(r), union.join());
    }

    @Test
    public void singleFail() {
        CompletableFuture<Response> future = new CompletableFuture<>();

        CompletableFutureWithCounter<Response> union = new CompletableFutureWithCounter<>(List.of(future));

        future.orTimeout(100, TimeUnit.MILLISECONDS);

        Assert.assertEquals(List.of(), union.join());
    }

    @Test
    public void okOkBad() {
        CompletableFuture<Response> future1 = new CompletableFuture<>();
        CompletableFuture<Response> future2 = new CompletableFuture<>();
        CompletableFuture<Response> future3 = new CompletableFuture<>();

        CompletableFutureWithCounter<Response> union = new CompletableFutureWithCounter<>(List.of(future1, future2, future3));

        Response r1 = new Response(true);
        Response r2 = new Response(true);
        Response r3 = new Response(false);
        future1.completeOnTimeout(r1, 100, TimeUnit.MILLISECONDS);
        future2.completeOnTimeout(r2, 1000, TimeUnit.MILLISECONDS);
        future3.completeOnTimeout(r3, 10, TimeUnit.MILLISECONDS);

        Assert.assertEquals(List.of(r1, r2, r3), union.join());
    }

    @Test
    public void skipSlow() {
        CompletableFuture<Response> future1 = new CompletableFuture<>();
        CompletableFuture<Response> future2 = new CompletableFuture<>();
        CompletableFuture<Response> future3 = new CompletableFuture<>();

        CompletableFutureWithCounter<Response> union = new CompletableFutureWithCounter<>(List.of(future1, future2, future3));

        Response r1 = new Response(true);
        Response r2 = new Response(true);
        Response r3 = new Response(true);
        future1.completeOnTimeout(r1, 100, TimeUnit.MILLISECONDS);
        future2.completeOnTimeout(r2, 200, TimeUnit.MILLISECONDS);
        future3.completeOnTimeout(r3, 1000, TimeUnit.MILLISECONDS);

        Assert.assertEquals(List.of(r1, r2), union.join());
    }
}
