package ru.yandex.juggler.validation;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Vladimir Gordiychuk
 */
public class JugglerValidatorTest {

    @Test
    public void emptyHostNameNotValid() {
        Assert.assertFalse(JugglerValidator.isHostNameValid(""));
    }

    @Test
    public void ruHostNameNotValid() {
        Assert.assertFalse(JugglerValidator.isHostNameValid("яндекс.рф"));
    }

    @Test
    public void firstLevelDomainValid() {
        Assert.assertTrue(JugglerValidator.isHostNameValid("yandex-team.ru"));
    }

    @Test
    public void secondLevelDomainValid() {
        Assert.assertTrue(JugglerValidator.isHostNameValid("solomon-dev.yandex.team.ru"));
    }

    @Test
    public void thirdLevelDomainValid() {
        Assert.assertTrue(JugglerValidator.isHostNameValid("man-03.solomon.search.yandex.net"));
    }

    @Test
    public void hostNameValidWithoutDomain() {
        Assert.assertTrue(JugglerValidator.isHostNameValid("solomon"));
    }

    @Test
    public void hostNameWithSpaceNotValid() {
        Assert.assertFalse(JugglerValidator.isHostNameValid("my super host"));
    }

    @Test
    public void emptyServiceNameNotValid() {
        Assert.assertFalse(JugglerValidator.isServiceNameValid(""));
    }

    @Test
    public void serviceNameWithSpaceNotValid() {
        Assert.assertFalse(JugglerValidator.isServiceNameValid("Free disk space"));
    }

    @Test
    public void serviceNameWithSpecialSymbolNotValid() {
        Assert.assertFalse(JugglerValidator.isServiceNameValid("disk=000123"));
    }

    @Test
    public void treeLikeServiceValid() {
        Assert.assertTrue(JugglerValidator.isServiceNameValid("/MemoryInfo/GCInfo/TimeMillisec"));
    }

    @Test
    public void serviceNameWithUnderscoreValid() {
        Assert.assertTrue(JugglerValidator.isServiceNameValid("PS_MarkSweep"));
    }

    @Test
    public void emptyTagNotValid() {
        Assert.assertFalse(JugglerValidator.isValidTagName(""));
    }

    @Test
    public void tagWithSpaceNotValid() {
        Assert.assertFalse(JugglerValidator.isValidTagName("my tag"));
    }

    @Test
    public void tagWithSpecialSymbolNotValid() {
        Assert.assertFalse(JugglerValidator.isValidTagName("disk=111"));
    }

    @Test
    public void tagWithValidName() {
        Assert.assertTrue(JugglerValidator.isValidTagName("disk_111"));
        Assert.assertTrue(JugglerValidator.isValidTagName("logsng_experiments_main_v_1.1"));
        Assert.assertTrue(JugglerValidator.isValidTagName("UntrimmedFreeChunks"));
        Assert.assertTrue(JugglerValidator.isValidTagName("kikimr_solomon_man"));
    }
}
