package ru.yandex.persqueue;

import ru.yandex.persqueue.impl.PersqueueClientImpl;
import ru.yandex.persqueue.read.ReadSession;
import ru.yandex.persqueue.read.settings.ReadSessionSettings;
import ru.yandex.persqueue.rpc.GrpcRpcPool;
import ru.yandex.persqueue.settings.GrpcTransportSettings;

/**
 * @author Vladimir Gordiychuk
 */
public interface PersqueueClient extends AutoCloseable {

    static PersqueueClient create(GrpcTransportSettings settings) {
        return new PersqueueClientImpl(settings.endpoint, new GrpcRpcPool(settings));
    }

    ReadSession createReadSession(ReadSessionSettings settings);

    @Override
    void close();
}
