package ru.yandex.persqueue.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

import com.github.luben.zstd.ZstdInputStream;
import com.google.protobuf.ByteString;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.UnexpectedResultException;
import org.anarres.lzo.LzopInputStream;

/**
 * @author Vladimir Gordiychuk
 */
public class Decode {
    private Decode() {
    }

    public static ByteString decodeToByteString(Codec codec, ByteString data) {
        if (codec == Codec.RAW) {
            return data;
        }

        try(var input = decodeStream(codec, data)) {
            return ByteString.readFrom(input);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream decodeStream(Codec codec, ByteString bytes) {
        return decodeStream(codec, bytes.newInput());
    }

    public static InputStream decodeStream(Codec codec, InputStream input) {
        try (input) {
            switch (codec) {
                case RAW:
                    return input;
                case ZSTD:
                    return new ZstdInputStream(input);
                case GZIP:
                    return new GZIPInputStream(input);
                case LZOP:
                    return new LzopInputStream(input);
                default:
                    throw new UnexpectedResultException("Unsupported codec: " + codec, StatusCode.UNSUPPORTED);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
