package ru.yandex.persqueue.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

import com.github.luben.zstd.ZstdOutputStream;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.UnexpectedResultException;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.LzopOutputStream;

/**
 * @author Vladimir Gordiychuk
 */
public class Encode {

    public static OutputStream encodeStream(Codec codec, OutputStream output) {
        try {
            switch (codec) {
                case RAW:
                    return output;
                case ZSTD:
                    return new ZstdOutputStream(output);
                case GZIP:
                    return new GZIPOutputStream(output);
                case LZOP:
                    LzoCompressor compressor = LzoLibrary.getInstance().newCompressor(LzoAlgorithm.LZO1X, null);
                    return new LzopOutputStream(output, compressor);
                default:
                    throw new UnexpectedResultException("Unsupported codec: " + codec, StatusCode.UNSUPPORTED);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
