package ru.yandex.persqueue.impl;

import ru.yandex.persqueue.PersqueueClient;
import ru.yandex.persqueue.read.ReadSession;
import ru.yandex.persqueue.read.impl.ReadSessionImpl;
import ru.yandex.persqueue.read.settings.ReadSessionSettings;
import ru.yandex.persqueue.rpc.RpcPool;

/**
 * @author Vladimir Gordiychuk
 */
public class PersqueueClientImpl implements PersqueueClient {
    private final String endpoint;
    private final RpcPool rpcPool;

    public PersqueueClientImpl(String endpoint, RpcPool rpcPool) {
        this.endpoint = endpoint;
        this.rpcPool = rpcPool;
    }

    @Override
    public ReadSession createReadSession(ReadSessionSettings settings) {
        return new ReadSessionImpl(endpoint, rpcPool, settings);
    }

    @Override
    public void close() {
    }
}
