package ru.yandex.persqueue.read;

import com.yandex.ydb.core.UnexpectedResultException;

/**
 * @author Vladimir Gordiychuk
 */
public interface PartitionStream {

    PartitionStreamKey getKey();

    long getAssignId();

    /**
     * Partition's topic path.
     */
    String getTopicPath();

    /**
     * Topic's instance cluster name
     */
    String getClusterName();

    /**
     * Partition.
     */
    long getPartition();

    /**
     * Request partition stream status.
     * Result will come to {@link ru.yandex.persqueue.read.event.PartitionStreamStatusEvent}.
     */
    void requestStatus();

    /**
     * Commit processed data offsets.
     * [startOffset, endOffset) will be committed. StartOffset, EndOffset - 1 could be only from read data.
     * Each offset could be committed only inside one range.
     * Real commit will be done only if there would be no gaps with not committed data in partition,
     * but client could send commit requests in random order.
     *
     * When real commit will be done, result will come to
     * {@link ru.yandex.persqueue.read.event.CommitAcknowledgementEvent}
     * If partition stream was destroyed, there would be no commit acks belonging to it.
     *
     * @throws UnexpectedResultException when client tries to commit any offset second time
     */
    void commit(long startOffset, long endOffset);

    /**
     * Commit single message
     */
    default void commit(long offset) {
        commit(offset, offset + 1);
    }

}
