package ru.yandex.persqueue.read;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamKey {
    public final String topic;
    public final String cluster;
    public final long partition;

    public PartitionStreamKey(String topic, String cluster, long partition) {
        this.topic = topic;
        this.cluster = cluster;
        this.partition = partition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PartitionStreamKey)) return false;

        PartitionStreamKey that = (PartitionStreamKey) o;

        if (partition != that.partition) return false;
        if (!topic.equals(that.topic)) return false;
        return cluster.equals(that.cluster);
    }

    @Override
    public int hashCode() {
        int result = topic.hashCode();
        result = 31 * result + cluster.hashCode();
        result = 31 * result + (int) (partition ^ (partition >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return topic + ":" + cluster + ":" + Long.toUnsignedString(partition);
    }
}
