package ru.yandex.persqueue.read.event;

import java.util.Map;

import com.google.protobuf.ByteString;

import ru.yandex.persqueue.codec.Codec;

/**
 * @author Vladimir Gordiychuk
 */
public interface Message extends Event {
    /**
     * User data.
     */
    ByteString getData();

    /**
     * Codec used to encode data
     */
    Codec getCodec();

    /**
     * Partition offset in partition that assigned for message.
     */
    long getOffset();

    /**
     * Sequence number that provided with message on write from client.
     */
    long getSeqNo();

    /**
     * Timestamp of creation of message provided on write from client.
     */
    long getCreateTimeMillis();

    /**
     * Extra fields provided by writer
     */
    Map<String, String> getExtraFields();

    /**
     * Commit current message
     */
    void commit();
}
