package ru.yandex.persqueue.read.event;

/**
 * Server request for creating partition stream
 *
 * @author Vladimir Gordiychuk
 */
public interface PartitionStreamCreateEvent extends Event {

    /**
     * Confirm partition stream creation.
     * This signals that user is ready to receive data from this partition stream.
     */
    void confirm();

    /**
     * Confirm partition stream creation.
     * Start reading from partition offset that is not less than readOffset.
     */
    void confirm(long readOffset);

    /**
     * Confirm partition stream creation.
     * Start reading from partition offset that is not less than readOffset.
     * All messages with offset less than commitOffset are processed by client.
     * Server will commit this position if this is not done yet.
     */
    void confirm(long readOffset, long commitOffset);
}
