package ru.yandex.persqueue.read.event;

/**
 * Server request for destroying partition stream.
 * Server can destroy partition stream gracefully for rebalancing among all topic clients.
 *
 * @author Vladimir Gordiychuk
 */
public interface PartitionStreamDestroyEvent extends Event {

    /**
     * @return Last offset of the partition stream that was committed.
     */
    long getCommittedOffset();

    /**
     * Confirm partition stream destruction.
     */
    void confirm();
}
