package ru.yandex.persqueue.read.event;

import ru.yandex.persqueue.read.PartitionStream;

/**
 * Status for partition stream requested via {@link PartitionStream#requestStatus()}
 *
 * @author Vladimir Gordiychuk
 */
public interface PartitionStreamStatusEvent extends Event {

    /**
     * @return committed offset.
     */
    long getCommittedOffset();

    /**
     * @return Offset of next message (that is not yet read by session).
     */
    long getReadOffset();

    /**
     * @return Offset of first not existing message in partition.
     */
    long getEndOffset();

    /**
     * Write watermark.
     * @return The last written timestamp of message in this partition stream.
     */
    long getWriteWatermark();
}
