package ru.yandex.persqueue.read.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nullable;

import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.UnexpectedResultException;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.PartitionStreamKey;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamMap {
    private final Map<PartitionStreamKey, PartitionStreamImpl> partitionStreamByKey = new HashMap<>();
    private final Long2ObjectMap<PartitionStreamImpl> partitionStreamByAssignId = new Long2ObjectOpenHashMap<>();

    @Nullable
    public PartitionStreamImpl get(long assignId) {
        return partitionStreamByAssignId.get(assignId);
    }

    public PartitionStreamImpl get(PartitionStreamKey key) {
        return partitionStreamByKey.get(key);
    }

    @Nullable
    public PartitionStream add(PartitionStreamImpl partitionStream) {
        var prevByAssignId = partitionStreamByAssignId.put(partitionStream.getAssignId(), partitionStream);
        if (prevByAssignId != null) {
            throw new UnexpectedResultException(
                    "Duplicate assignId prev " + prevByAssignId + " new " + partitionStream,
                    StatusCode.INTERNAL_ERROR);
        }

        var prevByKey = partitionStreamByKey.put(partitionStream.getKey(), partitionStream);
        if (prevByKey == null) {
            return null;
        }

        prevByKey.close();
        partitionStreamByAssignId.remove(prevByKey.getAssignId(), prevByKey);
        return prevByKey;
    }

    public boolean contains(PartitionStreamImpl partitionStream) {
        return partitionStreamByAssignId.get(partitionStream.getAssignId()) == partitionStream;
    }

    public boolean remove(PartitionStreamImpl partitionStream) {
        return partitionStreamByAssignId.remove(partitionStream.getAssignId(), partitionStream)
                && partitionStreamByKey.remove(partitionStream.getKey(), partitionStream);
    }

    public Collection<PartitionStreamImpl> partitionStreams() {
        return partitionStreamByKey.values();
    }

    public boolean isEmpty() {
        return partitionStreamByAssignId.isEmpty();
    }

    public void clear() {
        partitionStreamByAssignId.clear();
        partitionStreamByKey.clear();
    }
}
