package ru.yandex.persqueue.read.impl.actor;

import java.util.List;

import com.yandex.ydb.core.Result;

import ru.yandex.persqueue.read.impl.Cookie;
import ru.yandex.persqueue.read.impl.PartitionStreamImpl;

/**
 * @author Vladimir Gordiychuk
 */
public class ActorEvents {
    private ActorEvents() {
    }

    public static final class Connect implements ActorEvent {

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onConnect(this);
        }
    }

    public static final class Disconnect implements ActorEvent {

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onDisconnect(this);
        }
    }

    public static final class ConfirmAssign implements ActorEvent {
        public final PartitionStreamImpl partitionStream;
        public final long readOffset;
        public final long commitOffset;

        public ConfirmAssign(PartitionStreamImpl partitionStream, long readOffset, long commitOffset) {
            this.partitionStream = partitionStream;
            this.readOffset = readOffset;
            this.commitOffset = commitOffset;
        }

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onConfirmAssign(this);
        }
    }

    public static final class ConfirmDestroy implements ActorEvent {
        public final PartitionStreamImpl partitionStream;

        public ConfirmDestroy(PartitionStreamImpl partitionStream) {
            this.partitionStream = partitionStream;
        }

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onConfirmDestroy(this);
        }
    }

    public static final class RequestPartitionStatus implements ActorEvent {
        public final PartitionStreamImpl partitionStream;

        public RequestPartitionStatus(PartitionStreamImpl partitionStream) {
            this.partitionStream = partitionStream;
        }

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onRequestPartitionStatus(this);
        }
    }

    public static final class Commit implements ActorEvent {
        public final Cookie cookie;
        public final PartitionStreamImpl partitionStream;

        public Commit(PartitionStreamImpl partitionStream, Cookie cookie) {
            this.cookie = cookie;
            this.partitionStream = partitionStream;
        }

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onCommit(this);
        }
    }

    public static final class MemoryChunkConsumed implements ActorEvent {
        public static final MemoryChunkConsumed INSTANCE = new MemoryChunkConsumed();

        private MemoryChunkConsumed() {
        }

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onMemoryChunkConsumed(this);
        }
    }

    public static final class OnNodesDiscovered implements ActorEvent {
        public final Result<List<String>> result;

        public OnNodesDiscovered(Result<List<String>> result) {
            this.result = result;
        }

        @Override
        public void dispatch(ActorEventHandler handler) {
            handler.onNodeDiscovered(this);
        }
    }
}
