package ru.yandex.persqueue.read.impl.actor;

import javax.annotation.Nullable;

import com.yandex.ydb.core.Status;

/**
 * @author Vladimir Gordiychuk
 */
public interface EventQueue<T> {

    void enqueue(T event);

    void onError(Status status);

    void onComplete();

    @Nullable
    T dequeue();

    /**
     * @return error status that lead to finish of producing new events
     */
    @Nullable
    Status getError();

    /**
     * @return {@code true} if completed and no new events will send
     */
    boolean isCompleted();

    /**
     * @return {@code true} if completed in any fashion: normally, or exceptionally.
     */
    boolean isDone();
}
