package ru.yandex.persqueue.read.impl.actor;

import com.yandex.ydb.core.Status;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage;

import ru.yandex.persqueue.read.impl.protocol.ServerResponseProto;

/**
 * @author Vladimir Gordiychuk
 */
public class ServerResponseObserver implements StreamObserver<MigrationStreamingReadServerMessage> {
    private final EventQueue<MigrationStreamingReadServerMessage> queue;

    public ServerResponseObserver(EventQueue<MigrationStreamingReadServerMessage> queue) {
        this.queue = queue;
    }

    @Override
    public void onNext(MigrationStreamingReadServerMessage message) {
        if (ServerResponseProto.isSuccess(message)) {
            queue.enqueue(message);
        } else {
            queue.onError(ServerResponseProto.getStatus(message));
        }
    }

    @Override
    public void onError(Status status) {
        queue.onError(status);
    }

    @Override
    public void onCompleted() {
        queue.onComplete();
    }
}
