package ru.yandex.persqueue.read.impl.event;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.CommitAcknowledgementEvent;
import ru.yandex.persqueue.read.event.EventHandler;

/**
 * @author Vladimir Gordiychuk
 */
public class CommitAcknowledgementEventImpl implements CommitAcknowledgementEvent {
    private final PartitionStream partitionStream;
    private final long committedOffset;

    public CommitAcknowledgementEventImpl(PartitionStream partitionStream, long committedOffset) {
        this.partitionStream = partitionStream;
        this.committedOffset = committedOffset;
    }

    @Override
    public long getCommittedOffset() {
        return committedOffset;
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onCommitAcknowledgement(this);
    }

    @Override
    public String toString() {
        return "CommitAcknowledgement{" +
                "key=" + partitionStream.getKey() +
                ", assignId=" + Long.toUnsignedString(partitionStream.getAssignId()) +
                ", committedOffset=" + Long.toUnsignedString(committedOffset) +
                '}';
    }
}
