package ru.yandex.persqueue.read.impl.event;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.PartitionStreamClosedEvent;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamClosedEventImpl implements PartitionStreamClosedEvent {
    private final PartitionStream partitionStream;

    public PartitionStreamClosedEventImpl(PartitionStream partitionStream) {
        this.partitionStream = partitionStream;
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onPartitionStreamClosed(this);
    }

    @Override
    public String toString() {
        return "PartitionStreamClosed{" +
                "key=" + partitionStream.getKey() +
                ", assignId=" + Long.toUnsignedString(partitionStream.getAssignId()) +
                '}';
    }
}
