package ru.yandex.persqueue.read.impl.event;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.PartitionStreamCreateEvent;
import ru.yandex.persqueue.read.impl.PartitionStreamImpl;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamCreateEventImpl implements PartitionStreamCreateEvent {
    private final PartitionStreamImpl partitionStream;

    public PartitionStreamCreateEventImpl(PartitionStreamImpl partitionStream) {
        this.partitionStream = partitionStream;
    }

    @Override
    public void confirm() {
        partitionStream.confirmAssign(0, 0);
    }

    @Override
    public void confirm(long readOffset) {
        partitionStream.confirmAssign(readOffset, 0);
    }

    @Override
    public void confirm(long readOffset, long commitOffset) {
        partitionStream.confirmAssign(readOffset, commitOffset);
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onPartitionStreamCreate(this);
    }

    @Override
    public String toString() {
        return "PartitionStreamCreate{" +
                "key=" + partitionStream.getKey() +
                ", assignId=" + Long.toUnsignedString(partitionStream.getAssignId()) +
                '}';
    }
}
