package ru.yandex.persqueue.read.impl.event;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.PartitionStreamDestroyEvent;
import ru.yandex.persqueue.read.impl.PartitionStreamImpl;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamDestroyEventImpl implements PartitionStreamDestroyEvent {
    private final PartitionStreamImpl partitionStream;
    private final long committedOffset;

    public PartitionStreamDestroyEventImpl(PartitionStreamImpl partitionStream, long committedOffset) {
        this.partitionStream = partitionStream;
        this.committedOffset = committedOffset;
    }

    @Override
    public long getCommittedOffset() {
        return committedOffset;
    }

    @Override
    public void confirm() {
        partitionStream.confirmDestroy();
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onPartitionStreamDestroy(this);
    }

    @Override
    public String toString() {
        return "PartitionStreamDestroy{" +
                "key=" + partitionStream.getKey() +
                ", assignId=" + Long.toUnsignedString(partitionStream.getAssignId()) +
                ", committedOffset=" + Long.toUnsignedString(committedOffset) +
                '}';
    }
}
