package ru.yandex.persqueue.read.impl.event;

import java.time.Instant;

import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.PartitionStatus;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.PartitionStreamStatusEvent;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamStatusEventImpl implements PartitionStreamStatusEvent {
    private final PartitionStream partitionStream;
    private final long committedOffset;
    private final long endOffset;
    private final long writeWatermark;

    public PartitionStreamStatusEventImpl(PartitionStream partitionStream, PartitionStatus status) {
        this.partitionStream = partitionStream;
        this.committedOffset = status.getCommittedOffset();
        this.endOffset = status.getEndOffset();
        this.writeWatermark = status.getWriteWatermarkMs();
    }

    @Override
    public long getCommittedOffset() {
        return committedOffset;
    }

    @Override
    public long getReadOffset() {
        return 0; // TODO: not supported yet in protocol
    }

    @Override
    public long getEndOffset() {
        return endOffset;
    }

    @Override
    public long getWriteWatermark() {
        return writeWatermark;
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onPartitionStreamStatus(this);
    }

    @Override
    public String toString() {
        return "PartitionStreamStatus{" +
                "key=" + partitionStream.getKey() +
                ", assignId=" + Long.toUnsignedString(partitionStream.getAssignId()) +
                ", committedOffset=" + Long.toUnsignedString(committedOffset) +
                ", endOffset=" + Long.toUnsignedString(endOffset) +
                ", writeWatermark=" + Instant.ofEpochMilli(writeWatermark) +
                '}';
    }
}
