package ru.yandex.persqueue.read.impl.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.UnexpectedResultException;
import com.yandex.ydb.persqueue.YdbPersqueueV1;
import com.yandex.ydb.persqueue.YdbPersqueueV1.KeyValue;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.DataBatch.PartitionData;

import ru.yandex.persqueue.codec.Codec;
import ru.yandex.persqueue.read.impl.PartitionStreamImpl;
import ru.yandex.persqueue.read.impl.event.MessageImpl;

/**
 * @author Vladimir Gordiychuk
 */
public class ServerResponseProtoConverter {
    public static List<MessageImpl> toMessages(PartitionStreamImpl partitionStream, PartitionData partitionData) {
        var result = new ArrayList<MessageImpl>();
        long latestOffset = Long.MAX_VALUE;
        for (var batch : partitionData.getBatchesList()) {
            var meta = toMeta(batch.getExtraFieldsList());
            for (var messageData : batch.getMessageDataList()) {
                var message = new MessageImpl(partitionStream, meta, messageData);
                result.add(message);
                long offset = message.getOffset();
                long expectOffset = latestOffset + 1;
                if (latestOffset != Long.MAX_VALUE && expectOffset != offset) {
                    throw new IllegalStateException("PartitionStream: " + partitionStream + ". " +
                            "Offsets don't match " + latestOffset + 1 + " != " + offset);
                }

                latestOffset = offset;
            }
        }

        return result;
    }

    public static Map<String, String> toMeta(List<KeyValue> list) {
        if (list.isEmpty()) {
            return Map.of();
        }

        return list.stream().collect(Collectors.toUnmodifiableMap(KeyValue::getKey, KeyValue::getValue));
    }

    public static Codec toCodec(YdbPersqueueV1.Codec codec) {
        switch (codec) {
            case CODEC_RAW:
                return Codec.RAW;
            case CODEC_GZIP:
                return Codec.GZIP;
            case CODEC_LZOP:
                return Codec.LZOP;
            case CODEC_ZSTD:
                return Codec.ZSTD;
            default:
                throw new UnexpectedResultException("Unsupported codec: " + codec, StatusCode.UNSUPPORTED);
        }
    }
}
