package ru.yandex.persqueue.read.impl.protocol.handler;

import com.google.protobuf.Message;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Assigned;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Committed;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.DataBatch;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.InitResponse;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.PartitionStatus;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Release;

/**
 * @author Vladimir Gordiychuk
 */
public class AbstractEventHandler implements TransportEventHandler {

    @Override
    public boolean onInit(InitResponse init) {
        throw unexpectedMessage(init);
    }

    @Override
    public boolean onAssign(Assigned assigned) {
        throw unexpectedMessage(assigned);
    }

    @Override
    public boolean onDataBatch(DataBatch dataBatch) {
        throw unexpectedMessage(dataBatch);
    }

    @Override
    public boolean onRelease(Release release) {
        throw unexpectedMessage(release);
    }

    @Override
    public boolean onCommit(Committed committed) {
        throw unexpectedMessage(committed);
    }

    @Override
    public boolean onPartitionStatus(PartitionStatus status) {
        throw unexpectedMessage(status);
    }

    @Override
    public void onError(Status status) {
        throw new IllegalStateException(this + " unexpected status " + status);
    }

    @Override
    public void onComplete() {
        throw new IllegalStateException(this + " unexpected status");
    }

    private IllegalStateException unexpectedMessage(Message message) {
        return new IllegalStateException(this + " unexpected message " + message.getDescriptorForType().getFullName());
    }
}
