package ru.yandex.persqueue.read.impl.protocol.handler;

import com.yandex.ydb.core.Status;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Assigned;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Committed;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.DataBatch;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.InitResponse;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.PartitionStatus;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Release;

/**
 * @author Vladimir Gordiychuk
 */
public interface TransportEventHandler {
    /**
     * Handshake response.
     */
    boolean onInit(InitResponse init);

    /**
     * Signal that partition is assigned to this read session.
     * Client must react on this signal by sending StartRead when ready.
     */
    boolean onAssign(Assigned assigned);

    /**
     * Read data.
     */
    boolean onDataBatch(DataBatch dataBatch);

    /**
     * Partition release request from server.
     */
    boolean onRelease(Release release);

    /**
     * Acknowledgement for commits.
     */
    boolean onCommit(Committed committed);

    /**
     * Response for status request.
     */
    boolean onPartitionStatus(PartitionStatus status);

    /**
     * Complete events stream by error took from server
     */
    void onError(Status status);

    /**
     * Complete events stream by server
     */
    void onComplete();
}
