package ru.yandex.persqueue.read.settings;

import java.util.concurrent.Executor;
import java.util.concurrent.Flow;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.util.concurrent.MoreExecutors;

import ru.yandex.persqueue.read.event.Event;

import static java.util.Objects.requireNonNull;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class EventHandlersSettings {
    public final Executor executor;
    public final Flow.Subscriber<? super Event> commonEvents;

    EventHandlersSettings(Builder builder) {
        this.executor = builder.executor;
        this.commonEvents = builder.commonEvents;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Executor executor = MoreExecutors.directExecutor();
        private Flow.Subscriber<? super Event> commonEvents;

        private Builder() {
        }

        /**
         * Executor for handlers.
         */
        public Builder executor(Executor executor) {
            this.executor = requireNonNull(executor);
            return this;
        }

        /**
         * You need manual confirm assign/destroy for partition and commit read data
         */
        public Builder commonHandler(Flow.Subscriber<? super Event> events) {
            this.commonEvents = requireNonNull(events);
            return this;
        }

        public EventHandlersSettings build() {
            return new EventHandlersSettings(this);
        }
    }
}
