package ru.yandex.persqueue.rpc;

import java.util.concurrent.CompletableFuture;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.rpc.OutStreamObserver;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.discovery.DiscoveryProtos.ListEndpointsResult;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadClientMessage;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage;
import com.yandex.ydb.persqueue.cluster_discovery.YdbPersqueueClusterDiscovery.DiscoverClustersRequest;
import com.yandex.ydb.persqueue.cluster_discovery.YdbPersqueueClusterDiscovery.DiscoverClustersResult;

/**
 * @author Vladimir Gordiychuk
 */
public interface PqRpc extends AutoCloseable {

    String nextToken();

    CompletableFuture<Result<DiscoverClustersResult>> discoverClusters(DiscoverClustersRequest request);

    CompletableFuture<Result<ListEndpointsResult>> discoverNodes();

    OutStreamObserver<MigrationStreamingReadClientMessage> readSessionV1(StreamObserver<MigrationStreamingReadServerMessage> observer);

    @Override
    void close();
}
