package ru.yandex.persqueue.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
@RunWith(Parameterized.class)
public class CodecTest {

    @Parameterized.Parameter(value = 0)
    public Codec codec;

    @Parameterized.Parameters(name = "{0}")
    public static Codec[] data() {
        return Codec.values();
    }

    @Test
    public void encodeDecode() throws IOException {
        String text = "persqueue";
        byte[] encoded = encode(codec, text.getBytes());
        byte[] decoded = decode(codec, encoded);
        assertEquals(text, new String(decoded));
    }

    @Test
    public void encodeDecodeRandom() throws IOException {
        var random = ThreadLocalRandom.current();
        byte[] expected = new byte[random.nextInt(1, 42 << 10)];
        random.nextBytes(expected);
        byte[] encoded = encode(codec, expected);
        byte[] decoded = decode(codec, encoded);
        assertArrayEquals(expected, decoded);
    }

    private static byte[] encode(Codec codec, byte[] data) throws IOException {
        var target = new ByteArrayOutputStream();
        try (var out = Encode.encodeStream(codec, target)) {
            out.write(data);
            out.flush();
        }
        return target.toByteArray();
    }

    private static byte[] decode(Codec codec, byte[] data) throws IOException {
        try (var input = Decode.decodeStream(codec, new ByteArrayInputStream(data))) {
            return input.readAllBytes();
        }
    }
}
