package ru.yandex.persqueue.read;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamKeyTest {

    @Test
    public void eq() {
        var left = new PartitionStreamKey("topic", "cluster", 1);
        var right = new PartitionStreamKey("topic", "cluster", 1);
        assertEquals(left, left);
        assertEquals(left, right);
        assertEquals(left.hashCode(), right.hashCode());
    }

    @Test
    public void notEq() {
        assertNotEquals(
                new PartitionStreamKey("topic1", "cluster", 1),
                new PartitionStreamKey("topic2", "cluster", 1));
        assertNotEquals(
                new PartitionStreamKey("topic", "cluster1", 1),
                new PartitionStreamKey("topic", "cluster2", 1));
        assertNotEquals(
                new PartitionStreamKey("topic", "cluster", 1),
                new PartitionStreamKey("topic", "cluster", 2));
    }
}
