package ru.yandex.persqueue.read.impl.actor;

import com.yandex.ydb.core.Status;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.InitResponse;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.persqueue.read.impl.protocol.ServerResponseProto;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class ServerResponseObserverTest {

    private EventQueue<MigrationStreamingReadServerMessage> queue;
    private ServerResponseObserver observer;

    @Before
    public void setUp() {
        queue = new EventQueueImpl<>(() -> {});
        observer = new ServerResponseObserver(queue);
    }

    @Test
    public void onNextSuccess() {
        var expected = ServerResponseProto.init(InitResponse.newBuilder()
                .setSessionId("assignedSessionId")
                .build());
        observer.onNext(expected);
        assertEquals(expected, queue.dequeue());
        assertFalse(queue.isDone());
    }

    @Test
    public void onNextError() {
        var expected = Status.of(StatusCode.BAD_SESSION);
        observer.onNext(ServerResponseProto.failed(expected));
        assertEquals(expected, queue.getError());
    }

    @Test
    public void onError() {
        var expected = Status.of(StatusCode.TRANSPORT_UNAVAILABLE);
        observer.onError(expected);
        assertEquals(expected, queue.getError());
    }

    @Test
    public void onComplete() {
        observer.onCompleted();
        assertTrue(queue.isCompleted());
    }
}
