package ru.yandex.persqueue.read.impl.protocol.handler;

import java.util.concurrent.ArrayBlockingQueue;

import com.google.common.base.MoreObjects;
import com.google.protobuf.Message;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Assigned;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Committed;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.DataBatch;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.InitResponse;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.PartitionStatus;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage.Release;

/**
 * @author Vladimir Gordiychuk
 */
public class EventHandlerStub implements TransportEventHandler {
    public final ArrayBlockingQueue<Event> events = new ArrayBlockingQueue<>(10000);

    @Override
    public boolean onInit(InitResponse init) {
        events.add(new Event(init));
        return true;
    }

    @Override
    public boolean onAssign(Assigned assigned) {
        events.add(new Event(assigned));
        return true;
    }

    @Override
    public boolean onDataBatch(DataBatch dataBatch) {
        events.add(new Event(dataBatch));
        return true;
    }

    @Override
    public boolean onRelease(Release release) {
        events.add(new Event(release));
        return true;
    }

    @Override
    public boolean onCommit(Committed committed) {
        events.add(new Event(committed));
        return true;
    }

    @Override
    public boolean onPartitionStatus(PartitionStatus status) {
        events.add(new Event(status));
        return true;
    }

    @Override
    public void onError(Status status) {
        events.add(new Event(status));
    }

    @Override
    public void onComplete() {
        events.add(new Event(true));
    }

    public static class Event {
        public Message message;
        public boolean complete;
        public Status error;

        public Event(Message message) {
            this.message = message;
        }

        public Event(boolean complete) {
            this.complete = complete;
        }

        public Event(Status status) {
            this.error = status;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this)
                    .omitNullValues()
                    .add("message", message)
                    .add("complete", complete)
                    .add("error", error)
                    .toString();
        }
    }
}
