package ru.yandex.persqueue.rpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.discovery.DiscoveryProtos.EndpointInfo;
import com.yandex.ydb.discovery.DiscoveryProtos.ListEndpointsResult;
import com.yandex.ydb.persqueue.YdbPersqueueV1.MigrationStreamingReadServerMessage;
import com.yandex.ydb.persqueue.cluster_discovery.YdbPersqueueClusterDiscovery.ClusterInfo;
import com.yandex.ydb.persqueue.cluster_discovery.YdbPersqueueClusterDiscovery.DiscoverClustersRequest;
import com.yandex.ydb.persqueue.cluster_discovery.YdbPersqueueClusterDiscovery.DiscoverClustersResult;
import com.yandex.ydb.persqueue.cluster_discovery.YdbPersqueueClusterDiscovery.ReadSessionClusters;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;

/**
 * @author Vladimir Gordiychuk
 */
public class PqRpcStub extends AbstractReferenceCounted implements PqRpc {
    public final String endpoint;
    private ConcurrentMap<StreamObserver<MigrationStreamingReadServerMessage>, OutReadSessionObserverStub> activeReadSessions = new ConcurrentHashMap<>();
    public final ConcurrentMap<String, String> endpointByCluster = new ConcurrentHashMap<>();

    public PqRpcStub(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String nextToken() {
        return "";
    }

    @Override
    public CompletableFuture<Result<DiscoverClustersResult>> discoverClusters(DiscoverClustersRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DiscoverClustersResult.Builder result = DiscoverClustersResult.newBuilder();
            for (var readParams : request.getReadSessionsList()) {
                result.addReadSessionsClusters(ReadSessionClusters.newBuilder()
                        .addAllClusters(endpointByCluster.entrySet().stream()
                                .map(entry -> ClusterInfo.newBuilder()
                                        .setAvailable(true)
                                        .setEndpoint(entry.getValue())
                                        .setName(entry.getKey())
                                        .build())
                                .collect(Collectors.toList()))
                        .build());
            }
            return Result.success(result.build());
        });
    }

    @Override
    public CompletableFuture<Result<ListEndpointsResult>> discoverNodes() {
        return CompletableFuture.supplyAsync(() -> {
            return Result.success(ListEndpointsResult.newBuilder()
                    .addEndpoints(EndpointInfo.newBuilder()
                            .setAddress(endpoint)
                            .build())
                    .build());
        });
    }

    @Override
    public OutReadSessionObserverStub readSessionV1(StreamObserver<MigrationStreamingReadServerMessage> observer) {
        var result = new OutReadSessionObserverStub(observer);
        activeReadSessions.put(observer, result);
        return result;
    }

    @Nullable
    public OutReadSessionObserverStub getActiveReadObserver() {
        var it = activeReadSessions.values().iterator();
        while (it.hasNext()) {
            var result = it.next();
            if (result.competed) {
                it.remove();
            } else {
                return result;
            }
        }
        return null;
    }

    @Override
    public void close() {
        release();
    }

    @Override
    protected void deallocate() {
        activeReadSessions.values().forEach(OutReadSessionObserverStub::onCompleted);
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        return this;
    }
}
