package ru.yandex.persqueue.rpc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import io.netty.util.IllegalReferenceCountException;

/**
 * @author Vladimir Gordiychuk
 */
public class RpcPoolStub implements RpcPool {
    private final ConcurrentMap<String, PqRpcStub> rpcByEndpoint = new ConcurrentHashMap<>();

    public RpcPoolStub() {
    }

    @Override
    public PqRpcStub getRpc(String endpoint) {
        return rpcByEndpoint.compute(endpoint, (key, prev) -> {
            if (prev == null || prev.refCnt() == 0) {
                return new PqRpcStub(endpoint);
            } else {
                try {
                    return (PqRpcStub) prev.retain();
                } catch (IllegalReferenceCountException e) {
                    return new PqRpcStub(endpoint);
                }
            }
        });
    }
}
