JAVA_LIBRARY(persqueue)

OWNER(g:solomon)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/contribs.inc)
INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/jdk.inc)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.persqueue
    SRCDIR src
    **/*.java
)

PEERDIR(
    kikimr/public/sdk/java/core
    iceberg/misc-local-actors #TODO: move actors to library

    contrib/java/org/slf4j/slf4j-api
    contrib/java/it/unimi/dsi/fastutil
    contrib/java/org/anarres/lzo/lzo-core/1.0.5
    contrib/java/com/github/luben/zstd-jni/1.3.2-4
)

EXCLUDE(
    # we use contrib/java/com/google/code/findbugs/jsr305/3.0.2 instead
    contrib/java/com/google/code/findbugs/annotations/2.0.3
)

CHECK_JAVA_DEPS(yes)

LINT(base)
END()

RECURSE(examples)
IF (NOT SANITIZER_TYPE)
    RECURSE_FOR_TESTS(ut)
ENDIF()

