package ru.yandex.staff;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author Vladimir Gordiychuk
 */
public interface StaffClient extends AutoCloseable {
    CompletableFuture<UserInfo> getUserInfo(String login);

    CompletableFuture<List<UserInfo>> getUserInfo(List<String> login);

    CompletableFuture<UserInfo> getUserInfoByTelegramLogin(String telegramLogin);

    CompletableFuture<List<StaffGroupMember>> getStaffGroupMembers(String groupId);

    CompletableFuture<List<StaffGroup>> getStaffGroup(List<String> groupIds);
}
