package ru.yandex.staff;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class StaffGroup {

    private static final String SERVICE_ROLE = "servicerole";
    private static final String SERVICE = "service";

    @JsonProperty("id")
    public int id;

    @JsonProperty("name")
    public String name;

    @JsonProperty("type")
    public String type;

    public boolean isService() {
        return SERVICE.equals(type) || SERVICE_ROLE.equals(type);
    }
}
