package ru.yandex.staff;

import java.util.List;

import javax.annotation.Nullable;

/**
 * @author Vladimir Gordiychuk
 */
public class UserInfo {
    private final long uid;
    private final String login;
    @Nullable
    private final String phone;
    private final boolean dismissed;
    private final List<String> telegramLogins;
    private final String firstName;
    private final String lastName;

    public UserInfo(long uid, String login, @Nullable String phone, boolean dismissed, List<String> telegramLogins,
                    String firstName, String lastName) {
        this.uid = uid;
        this.login = login;
        this.phone = phone;
        this.dismissed = dismissed;
        this.telegramLogins = telegramLogins;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public long getUid() {
        return uid;
    }

    public String getLogin() {
        return login;
    }

    @Nullable
    public String getPhone() {
        return phone;
    }

    public boolean isDismissed() {
        return dismissed;
    }

    public List<String> getTelegramLogins() {
        return telegramLogins;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    @Override
    public String toString() {
        return "UserInfo{" +
                "uid=" + uid +
                ", login='" + login + '\'' +
                ", firstName='" + firstName + '\'' +
                ", lastName='" + lastName + '\'' +
                ", phone='" + phone + '\'' +
                ", telegramLogins='" + telegramLogins + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UserInfo userInfo = (UserInfo) o;

        if (uid != userInfo.uid) return false;
        if (dismissed != userInfo.dismissed) return false;
        if (login != null ? !login.equals(userInfo.login) : userInfo.login != null) return false;
        if (firstName != null ? !firstName.equals(userInfo.firstName) : userInfo.firstName != null) return false;
        if (lastName != null ? !lastName.equals(userInfo.lastName) : userInfo.lastName != null) return false;
        if (phone != null ? !phone.equals(userInfo.phone) : userInfo.phone != null) return false;
        return telegramLogins != null ? telegramLogins.equals(userInfo.telegramLogins)
                : userInfo.telegramLogins == null;
    }

    @Override
    public int hashCode() {
        int result = (int) (uid ^ (uid >>> 32));
        result = 31 * result + (login != null ? login.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (firstName != null ? firstName.hashCode() : 0);
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (dismissed ? 1 : 0);
        result = 31 * result + (telegramLogins != null ? telegramLogins.hashCode() : 0);
        return result;
    }
}
