package ru.yandex.staff.exceptions;

import java.net.http.HttpResponse;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class StaffClientException extends RuntimeException {
    public StaffClientException(String message) {
        super(message);
    }

    public static StaffClientException fromHttpResponse(HttpResponse<String> response) {
        int code = response.statusCode();
        String body = response.body();
        if (code == HttpStatus.SC_404_NOT_FOUND) {
            return new StaffNotFoundException(body);
        }
        return new UnknownStaffException(code + ": " + body);
    }
}
