package ru.yandex.staff.http;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Vladimir Gordiychuk
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class StaffPersonResponse {
    @JsonProperty("login")
    public String login;
    @JsonProperty("uid")
    public long uid;
    @JsonProperty("phones")
    public List<Phone> phones = new ArrayList<>();
    @JsonProperty("official")
    public Official official = new Official();
    @JsonProperty("name")
    public Name name = new Name();
    @JsonProperty("accounts")
    public List<Account> accounts = new ArrayList<>();

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Phone {
        @JsonProperty("kind")
        public String kind;
        @JsonProperty("type")
        public String type;
        @JsonProperty("number")
        public String number;
        @JsonProperty("is_main")
        public boolean main;
    }

    public static class Official {
        @JsonProperty("is_dismissed")
        public boolean dismissed;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Name {
        @JsonProperty("first")
        public MultilanguageString first;
        @JsonProperty("last")
        public MultilanguageString last;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class MultilanguageString {
        @JsonProperty("ru")
        public String ru;
        @JsonProperty("en")
        public String en;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Account {
        @JsonProperty("type")
        public String type;
        @JsonProperty("value")
        public String value;
        @JsonProperty("private")
        public boolean isPrivate;
    }
}
