package ru.yandex.staff.http;

import java.util.concurrent.ForkJoinPool;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.staff.StaffClient;
import ru.yandex.staff.StaffClientOptions;
import ru.yandex.staff.StaffClients;
import ru.yandex.staff.UserInfo;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class HttpStaffClientTest {
    private StaffClient client;

    @Before
    public void setUp() throws Exception {
        StaffClientOptions opts = StaffClientOptions.newBuilder()
                .setExecutor(ForkJoinPool.commonPool())
                .setOauthToken("hi")
                .build();

        client = StaffClients.create(opts);
    }

    @After
    public void tearDown() throws Exception {
        client.close();
    }

    @Ignore
    @Test
    public void userInfo() {
        UserInfo info = client.getUserInfo("uranix").join();
        UserInfo infoByTelegram = client.getUserInfoByTelegramLogin("UrAn1X").join();

        assertThat(info.getLogin(), equalTo("uranix"));
        assertThat(info.getUid(), equalTo(1120000000073101L));
        assertThat(info.isDismissed(), equalTo(false));
        assertThat(info.getTelegramLogins().size(), equalTo(1));
        assertThat(info.getTelegramLogins().get(0), equalTo("uran1x"));
        assertThat(info, equalTo(infoByTelegram));
    }
}
