package ru.yandex.staff.http;

import java.io.IOException;
import java.io.InputStream;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.iterableWithSize;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class StaffPersonResponseTest {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void successResponse() throws IOException {
        StaffPersonResponse person = parsePersonsResponse("successPersonResponse.json");

        assertThat(person.login, equalTo("gordiychuk"));
        assertThat(person.uid, equalTo(1120000000047567L));
        assertThat(person.phones, iterableWithSize(1));
        assertThat(person.phones, iterableWithSize(1));
        assertThat(person.phones.get(0).number, equalTo("+79252767935"));
        assertThat(person.phones.get(0).main, equalTo(true));
    }

    private StaffPersonResponse parsePersonsResponse(String path) throws IOException {
        return mapper.readValue(load(path), StaffPersonResponse.class);
    }

    private InputStream load(String res) {
        return StaffPersonResponseTest.class.getResourceAsStream(res);
    }

}
