package ru.yandex.yasms;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class Status {
    private final Code code;
    private final String details;

    public Status(Code code, String details) {
        this.code = code;
        this.details = details;
    }

    public Status(Code code) {
        this(code, "");
    }

    public Code getCode() {
        return code;
    }

    public String getDetails() {
        return details;
    }

    @Override
    public String toString() {
        return code + ": " + details;
    }

    public enum Code {
        SUCCESS("SUCCESS"),
        INVALID_REQUEST("INVALIDREQUEST"),
        BAD_PHONE("BADPHONE"),
        DONT_KNOW_YOU("DONTKNOWYOU"),
        INTERNAL_ERROR("INTERROR"),
        LIMIT_EXCEEDED("LIMITEXCEEDED"),
        NO_CURRENT("NOCURRENT"),
        NO_PHONE("NOPHONE"),
        NO_RIGHTS("NORIGHTS"),
        NO_ROUTE("NOROUTE"),
        NO_SENDER("NOSENDER"),
        NO_TEXT("NOTEXT"),
        NO_UID("NO_UID"),
        PERMANENT_BLOCK("PERMANENTBLOCK"),
        PHONE_BLOCKED("PHONEBLOCKED"),
        UID_LIMITEXCEEDED("UIDLIMITEXCEEDED"),;

        private String str;

        Code(String codes) {
            this.str = codes;
        }

        public static Code byCode(String strCode) {
            for (Code code : values()) {
                if (code.str.equals(strCode)) {
                    return code;
                }
            }

            throw new UnsupportedOperationException("Unsupported status code: " + strCode);
        }
    }
}
