package ru.yandex.yasms;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class YasmsClientOptions {
    private final String address;
    private final String sender;
    private final MetricRegistry registry;

    private YasmsClientOptions(Builder builder) {
        this.address = builder.address != null
                ? builder.address
                : "http://sms.passport.yandex.ru";
        this.sender = Objects.requireNonNull(builder.sender);
        this.registry = builder.metricRegistry != null
                ? builder.metricRegistry
                : MetricRegistry.root();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAddress() {
        return address;
    }

    public String getSender() {
        return sender;
    }

    public MetricRegistry getRegistry() {
        return registry;
    }

    public static class Builder {
        @Nullable
        private String address;
        @Nullable
        private String sender;
        @Nullable
        private MetricRegistry metricRegistry;

        public Builder setAddress(String address) {
            this.address = "".equals(address) ? null : address;
            return this;
        }

        public Builder setSender(String sender) {
            this.sender = "".equals(sender) ? null : sender;
            return this;
        }

        public Builder setRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public YasmsClientOptions build() {
            return new YasmsClientOptions(this);
        }
    }
}
