package ru.yandex.yasms.http;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

/**
 * @author Vladimir Gordiychuk
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class SendSmsResponse {
    @JacksonXmlProperty(localName = "message-sent")
    public Message message;
    @JacksonXmlProperty(localName = "error")
    public String error = "";
    @JacksonXmlProperty(localName = "errorcode")
    public String errorCode = "";

    public boolean isSuccess() {
        return errorCode.isEmpty();
    }

    public String getError() {
        return error;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getMessageId() {
        if (message == null) {
            return "";
        }

        return message.id;
    }

    @Override
    public String toString() {
        return "SendSmsResponse{" +
                "message=" + message +
                ", error='" + error + '\'' +
                ", errorCode='" + errorCode + '\'' +
                '}';
    }

    public static class Message {
        @JacksonXmlProperty(localName = "id", isAttribute = true)
        public String id = "";

        @Override
        public String toString() {
            return "Message{" +
                    "id='" + id + '\'' +
                    '}';
        }
    }
}
