package ru.yandex.yasms.http;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Counter;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.LazyGaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.yasms.Status;

/**
 * @author Vladimir Gordiychuk
 */
public class YasmsClientMetrics {
    private final MetricRegistry registry;

    private final Rate started;
    private final Rate completed;
    private final LazyGaugeInt64 inFlight;
    private final Histogram elapsedTimeMillis;
    private ConcurrentMap<Status.Code, Counter> statusCounts = new ConcurrentHashMap<>();

    public YasmsClientMetrics(MetricRegistry registry) {
        this.registry = registry;

        started = registry.rate("yasms.client.request.started");
        completed = registry.rate("yasms.client.request.completed");
        inFlight = registry.lazyGaugeInt64("yasms.client.request.inFlight", () -> started.get() - completed.get());
        elapsedTimeMillis = registry.histogramRate("yasms.client.request.elapsedTimeMillis", Histograms.exponential(13, 2, 16));
    }

    public void started() {
        this.started.inc();
    }

    public void complete(long elapsedNanos, Status.Code status) {
        completed.inc();
        elapsedTimeMillis.record(TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
        statusCounts.computeIfAbsent(status,
                code -> registry.counter("yasms.client.request.status", Labels.of("code", code.name())))
                .inc();
    }
}
