package ru.yandex.yasms.http;

import java.io.IOException;
import java.io.InputStream;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.junit.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;

/**
 * @author Vladimir Gordiychuk
 */
public class SendSmsResponseTest {
    private XmlMapper mapper = new XmlMapper();

    @Test
    public void parseSuccess() throws IOException {
        SendSmsResponse response = parseResponse("successSendResponse.xml");
        assertThat(response.getError(), isEmptyOrNullString());
        assertThat(response.getErrorCode(), isEmptyOrNullString());
        assertThat(response.getMessageId(), equalTo("127000000003456"));
    }

    @Test
    public void parseFailed() throws IOException {
        SendSmsResponse response = parseResponse("failedSendResponse.xml");
        assertThat(response.getMessageId(), isEmptyOrNullString());
        assertThat(response.getError(), equalTo("User does not have an active phone to recieve messages"));
        assertThat(response.getErrorCode(), equalTo("NOCURRENT"));
    }

    private SendSmsResponse parseResponse(String path) throws IOException {
        return mapper.readValue(load(path), SendSmsResponse.class);
    }

    private InputStream load(String res) {
        return SendSmsResponseTest.class.getResourceAsStream(res);
    }
}
