package ru.yandex.solomon.yasm.expression.ast;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.yasm.expression.grammar.SignalPattern;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmAstArgList extends YasmAst {
    private final List<YasmAst> args;

    private static Stream<YasmAst> expandPatterns(YasmAst tail) {
        if (tail instanceof YasmAstIdent) {
            YasmAstIdent astIdent = (YasmAstIdent) tail;
            SignalPattern pattern = new SignalPattern(astIdent.getIdent());
            return pattern.generate();
        }
        return Stream.of(tail);
    }

    private YasmAstArgList(List<YasmAst> head, YasmAst tail) {
        super(Type.ARG_LIST);
        args = Stream.concat(
                head.stream(),
                expandPatterns(tail)
        ).collect(Collectors.toList());
    }

    public YasmAstArgList() {
        super(Type.ARG_LIST);
        args = List.of();
    }

    public YasmAstArgList(YasmAst... args) {
        super(Type.ARG_LIST);
        this.args = Arrays.stream(args)
                .flatMap(YasmAstArgList::expandPatterns)
                .collect(Collectors.toList());
    }

    public YasmAstArgList with(YasmAst other) {
        return new YasmAstArgList(args, other);
    }

    public List<YasmAst> getArgs() {
        return args;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YasmAstArgList that = (YasmAstArgList) o;
        return Objects.equals(args, that.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(args);
    }

    @Override
    public String toString() {
        return "ArgList{" + args + '}';
    }
}
