package ru.yandex.solomon.yasm.expression.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmAstCall extends YasmAst {
    private final String func;
    private final List<YasmAst> args;

    public YasmAstCall(String func, YasmAstArgList args) {
        super(Type.CALL);
        this.func = func;
        this.args = args.getArgs();
    }

    public String getFunc() {
        return func;
    }

    public List<YasmAst> getArgs() {
        return args;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YasmAstCall that = (YasmAstCall) o;
        return Objects.equals(func, that.func) &&
                Objects.equals(args, that.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(func, args);
    }

    @Override
    public String toString() {
        return func + '(' +
                args.stream()
                        .map(Object::toString)
                        .collect(Collectors.joining(", "))
                + ')';
    }
}
