package ru.yandex.solomon.yasm.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Ident may be either a signal name patten (requests_<2xx|5xx>_summ) or a named constant (Ki, Gi, etc)
 * Which one may be reliably detected only using the call signature
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmAstIdent extends YasmAst {
    private final String ident;

    public YasmAstIdent(String ident) {
        super(Type.IDENT);
        this.ident = ident;
    }

    public String getIdent() {
        return ident;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YasmAstIdent that = (YasmAstIdent) o;
        return Objects.equals(ident, that.ident);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ident);
    }

    @Override
    public String toString() {
        return "Ident{" + ident + '}';
    }
}
