package ru.yandex.solomon.yasm.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmAstNumber extends YasmAst {
    private final String token;
    private final double val;

    public YasmAstNumber(String v) {
        super(Type.NUMBER);
        token = v;
        val = Double.parseDouble(v);
    }

    /* Raw value, Yasm relies on leading zeros in quant */
    public String getToken() {
        return token;
    }

    public double getValue() {
        return val;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YasmAstNumber that = (YasmAstNumber) o;
        return Double.compare(that.val, val) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(val);
    }

    @Override
    public String toString() {
        return "Number{" + val + '}';
    }
}
